define(['bower_components/angular/angular', 'app', 'moment', 'fhirPatientService'], function(angular, app, fhirPatient) {
		'use strict';

		app.controller('GoalsController', function($scope, $state, $stateParams, $filter, formatter, focusService, HomePageConstants, GoalsService, fhirPatient) {


			var service = GoalsService.instance($stateParams.section),
				today = new Date();

			$scope.getDetails = function(item) {
				$stateParams.id = item ? service.idGetter(item) : null;
				$state.go(".entry", $stateParams);
			};

			angular.extend($scope, HomePageConstants['goalHistory'].scope);

			$scope.filter = {
				service: service
			};

			var defaultFilters = {
				startDate: formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta(today, {
					years: -1
				}, "front")),
				endDate: formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta(today, {
					years: 1
				}, "front")),
				status: MyStoryConstants['goals'].scope.defaultStatus,
				subject: MyStoryConstants['goals'].scope.subject
			};

			$scope.filter.defaults = {};
			$scope.filter.defaults = defaultFilters;

			fhirPatient.fetch().then(function(response) {
				service.config.object.patient = response;
				if (!service.dataPointers.list) {
					service.fetch(service.dataPointers.filters || $scope.filter.defaults)
				}
			});

			$scope.getCompletedStepCount = function(steps) {
				var completedSteps = 0;
				steps.forEach(function(step) {
					if (step.authorString) {
						completedSteps++;
					}
				});
				return completedSteps;
			};

			$scope.getNextDueDate = function(steps) {
				for (var i = 0; i < steps.length; i++) {
					if (!steps[i].authorString) {
						return steps[i].time;
					}
				}
			};

			$scope.getDaysRemaining = function(date) {
				var todaysDate = moment(today),
					endDate = moment(date),
					difference = endDate.diff(todaysDate, 'days');
				return Math.abs(difference) + (difference < 0 ? " Days Past Due" : " Days Remaining");
			};

		});
	}
);
